// LPC2148.h : register definitions for the LPC2148 variant
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// Hardware register definitions for the Philips LPC2148
// microcontroller with ARM7TDMI core.

// All unspecified bits should be written as zeros.

#ifndef __LPC2148_H_INCLUDED__
#define __LPC2148_H_INCLUDED__

// Specify the variant in use.
#define LPC_PART 2148

// Define the I/O module hardware register sets.
#include <LPC2xxx.h>

/****************************************************************/
// Define the instances of the I/O modules available on the LPC2148.
// First are the VPB peripherals in 16K blocks from 0xe0000000 to
// 0xe0200000:

#define WDT    (* (struct WDT_registers_t *)	0xe0000000) 
#define TIMER0 (* (struct TIMER_registers_t *)	0xe0004000) 
#define TIMER1 (* (struct TIMER_registers_t *)	0xe0008000) 
#define UART0  (* (struct UART_registers_t *) 	0xe000c000)
#define UART1  (* (struct UART_registers_t *) 	0xe0010000)
#define PWM0   (* (struct PWM_registers_t *)    0xe0014000)
// unused                                       0xe0018000
//  I2C0                                        0xe001c000
#define SPI0   (* (struct SPI_registers_t *)    0xe0020000)
#define RTC    (* (struct RTC_registers_t *)  	0xe0024000)
#define GPIO0  (* (struct GPIO_registers_t *) 	0xe0028000)
#define GPIO1  (* (struct GPIO_registers_t *) 	0xe0028010)
#define PCB    (* (struct PCB_registers_t *) 	0xe002c000)
// unused                                       0xe0030000
#define ADC0   (* (struct ADC_registers_t *)    0xe0034000)
// unused                                       0xe0038000 - 0xe0058000
//  I2C1                                        0xe005c000 
#define ADC1   (* (struct ADC_registers_t *)    0xe0060000)
// unused                                       0xe0064000
#define SPI1   (* (struct SSP_registers_t *)    0xe0068000)
#define DAC0   (* (struct DAC_registers_t *)    0xe006c000)
// unused                                       0xe0070000 - 0xe008c000
// USB                                          0xe0090000
// unused                                       0xe0094000 - 0xe01f8000


// Next are the AHB peripherals from 0xffe00000 to 0xffffffff:

#define MAM    (* (struct MAM_registers_t *)  	0xe01fc000)
#define SCB    (* (struct SCB_registers_t *)  	0xe01fc040)
#define VIC    (* (struct VIC_registers_t *)  	0xfffff000)

#endif // __LPC2148_H_INCLUDED__
