// LPC2138.h : register definitions for the LPC2138 variant
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// Hardware register definitions for the Philips LPC2138
// microcontroller with ARM7TDMI core.

// All unspecified bits should be written as zeros.

#ifndef __LPC2138_H_INCLUDED__
#define __LPC2138_H_INCLUDED__

// Specify the variant in use.
#define LPC_PART 2138

// Define the I/O module hardware register sets.
#include <LPC2xxx.h>

/****************************************************************/
// This is the part ID returned by the bootloader IAP API.
#define LPC2138_PART_ID		0x0002ff25
#define LPC2xxx_PART_ID  (LPC2138_PART_ID)

/****************************************************************/
// Define names and function codes for configuring the ADC pins in the
// Pin Connect Block.  Unfortunately, the associated pin function
// codes vary pin by pin. These values are not universal for the
// LPC2xxx variants.

#define ADC0_0_PIN PIN0_27
#define ADC0_1_PIN PIN0_28
#define ADC0_2_PIN PIN0_29
#define ADC0_3_PIN PIN0_30
#define ADC0_4_PIN PIN0_25
#define ADC0_5_PIN PIN0_26
#define ADC0_6_PIN PIN0_4
#define ADC0_7_PIN PIN0_5

#define ADC0_0_FUNCTION  1
#define ADC0_1_FUNCTION  1
#define ADC0_2_FUNCTION  1
#define ADC0_3_FUNCTION  1
#define ADC0_4_FUNCTION  1
#define ADC0_5_FUNCTION  1
#define ADC0_6_FUNCTION  3
#define ADC0_7_FUNCTION  3

#define ADC1_0_PIN PIN0_6
#define ADC1_1_PIN PIN0_8
#define ADC1_2_PIN PIN0_10
#define ADC1_3_PIN PIN0_12
#define ADC1_4_PIN PIN0_13
#define ADC1_5_PIN PIN0_15
#define ADC1_6_PIN PIN0_21
#define ADC1_7_PIN PIN0_22

#define ADC1_0_FUNCTION  3
#define ADC1_1_FUNCTION  3
#define ADC1_2_FUNCTION  3
#define ADC1_3_FUNCTION  3 
#define ADC1_4_FUNCTION  3
#define ADC1_5_FUNCTION  3
#define ADC1_6_FUNCTION  2
#define ADC1_7_FUNCTION  1

/****************************************************************/
// Define the instances of the I/O modules available on the LPC2138.

#define WDT    (* (struct WDT_registers_t *)	0xe0000000) 
#define TIMER0 (* (struct TIMER_registers_t *)	0xe0004000) 
#define TIMER1 (* (struct TIMER_registers_t *)	0xe0008000) 
#define UART0  (* (struct UART_registers_t *) 	0xe000c000)
#define UART1  (* (struct UART_registers_t *) 	0xe0010000)
#define PWM0   (* (struct PWM_registers_t *)    0xe0014000)
#define SPI0   (* (struct SPI_registers_t *)    0xe0020000)
#define RTC    (* (struct RTC_registers_t *)  	0xe0024000)
#define GPIO0  (* (struct GPIO_registers_t *) 	0xe0028000)
#define GPIO1  (* (struct GPIO_registers_t *) 	0xe0028010)
#define PCB    (* (struct PCB_registers_t *) 	0xe002c000)
#define ADC0   (* (struct ADC_registers_t *)    0xe0034000)
#define ADC1   (* (struct ADC_registers_t *)    0xe0060000)
#define SPI1   (* (struct SSP_registers_t *)    0xe0068000)
#define DAC0   (* (struct DAC_registers_t *)    0xe006c000)
#define MAM    (* (struct MAM_registers_t *)  	0xe01fc000)
#define SCB    (* (struct SCB_registers_t *)  	0xe01fc040)
#define VIC    (* (struct VIC_registers_t *)  	0xfffff000)

#endif // __LPC2138_H_INCLUDED__
