// LPC2106.h : register definitions for the LPC2106 variant
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// Hardware register definitions for the Philips LPC2106
// microcontroller with ARM7TDMI core.

#ifndef __LPC2106_H_INCLUDED__
#define __LPC2106_H_INCLUDED__

// Specify the variant in use.
#define LPC_PART 2106

// Define the I/O module hardware register sets.
#include <LPC2xxx.h>

/****************************************************************/
// Define the instances of the I/O modules available on the LPC2106.

// This list may not be complete.
#define TIMER0 (* (struct TIMER_registers_t *)	0xe0004000) 
#define TIMER1 (* (struct TIMER_registers_t *)	0xe0008000) 
#define UART0  (* (struct UART_registers_t *) 	0xe000c000)
#define UART1  (* (struct UART_registers_t *) 	0xe0010000)
#define SPI0   (* (struct SPI_registers_t *)    0xe0020000)
#define GPIO0  (* (struct GPIO_registers_t *) 	0xe0028000)
#define PCB    (* (struct PCB_registers_t *) 	0xe002c000)
#define MAM    (* (struct MAM_registers_t *)  	0xe01fc000)
#define SCB    (* (struct SCB_registers_t *)  	0xe01fc040)
#define VIC    (* (struct VIC_registers_t *)  	0xfffff000)

#endif // __LPC2138_H_INCLUDED__
