// LED_indicators.c : interface to an array of indicator LEDS
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#include <libLPC2xxx.h>
#include <LED_indicators.h>
#include <errcodes.h>

/****************************************************************/
// If no mask is defined, then don't include the API.
#if CONFIG_LED_MASK
int
LED_indicators_init(void)
{
  // make sure all lamps are off
  CONFIG_LED_GPIO.IOCLR = CONFIG_LED_MASK & ~CONFIG_LED_ACTIVE_LOW_MASK;

#if CONFIG_LED_ACTIVE_LOW_MASK
  CONFIG_LED_GPIO.IOSET = CONFIG_LED_MASK & CONFIG_LED_ACTIVE_LOW_MASK;
#endif

  // set all indicator LED lines to outputs
  CONFIG_LED_GPIO.IODIR |= CONFIG_LED_MASK;

  return ERRNOERROR;
}

int
LED_indicators_set( unsigned value )
{
  // Convert the active high bitmask argument to the actual port bit
  // values; the bits are shifted from the LSB position to the
  // position within the port, and then any bits corresponding to
  // active low outputs are inverted.
  unsigned pattern = (value << CONFIG_LED_SHIFT) ^ CONFIG_LED_ACTIVE_LOW_MASK;

  // clear any zeros
  CONFIG_LED_GPIO.IOCLR = ~pattern & CONFIG_LED_MASK;

  // set any ones
  CONFIG_LED_GPIO.IOSET = pattern & CONFIG_LED_MASK;  

  return ERRNOERROR;
}
#endif

/****************************************************************/
// If no mask is defined, then don't include the API.
#if CONFIG_CPU_LED_MASK
void CPU_LED_on(void)
{
#if CONFIG_CPU_LED_ACTIVE_LOW
  CONFIG_CPU_LED_GPIO.IOCLR = CONFIG_CPU_LED_MASK;  // led on
#else
  CONFIG_CPU_LED_GPIO.IOSET = CONFIG_CPU_LED_MASK;  // led on
#endif
}

void CPU_LED_off(void)
{
#if CONFIG_CPU_LED_ACTIVE_LOW
  CONFIG_CPU_LED_GPIO.IOSET = CONFIG_CPU_LED_MASK;  // led off
#else
  CONFIG_CPU_LED_GPIO.IOCLR = CONFIG_CPU_LED_MASK;  // led off
#endif
}
#endif

/****************************************************************/
