// ADC.h : interface to LPC2xxx on-chip A/D converters
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#ifndef __ADC_H_INCLUDED__
#define __ADC_H_INCLUDED__

#include <libLPC2xxx.h> // for the correct hardware definition

// Some basic polled conversion routines.
extern void ADC_start_conversion( struct ADC_registers_t *ADC, int channel );
extern int  ADC_is_data_ready   ( struct ADC_registers_t *ADC );
extern int  ADC_read_result     ( struct ADC_registers_t *ADC );

#endif // __ADC_H_INCLUDED__
