// simulate-kalman.c : trivial linear system simulator to test Kalman filter and LQR
// This file is part of ArtLPC. 
// This file is placed into the public domain.

// This is doomed to success, since the simulation is a noise free
// linear system, so of course a properly coded Kalman/LQR controller
// will stabilize it as long as the system is controllable.  This is
// just intended as a bug check on the Kalman/LQR code.

#include <stdio.h>

#define ACCEL_GYRO_MODEL 1
#define ACCEL_ONLY_MODEL 2
#define POSITION_SENSOR_MODEL 3
#define MODEL 3

#define DT 0.005

#include "matrix.c"          // define some minimal linear algebra routines

#if MODEL==ACCEL_GYRO_MODEL
#include "linear-control.c"  // define the linear control state and functions
#endif

#if MODEL==ACCEL_ONLY_MODEL
#include "linear-control-no-gyro.c"  // define the linear control state and functions
#endif

#if MODEL==POSITION_SENSOR_MODEL
#include "linear-control-pitch-encoder.c"  // define the linear control state and functions
#endif

/****************************************************************/
int main(int argc, char **argv)
{
  double t;
  // Initialize the system to some reasonable initial state.
  modelX[0] = 0.0;    // linear position
  modelX[1] = 0.0;    // linear velocity
  modelX[2] = 0.1;    // body angle
  modelX[3] = 0.0;    // body angular velocity

  matrix_zero( modelU, NCONTROLS ); // no initial torque
  matrix_zero( modelY, NOUTPUTS );

  // Start the state estimate off with an error.
  matrix_zero( modelXe, NSTATES );

  // run the system for an interval
  for ( t = 0.0; t < 5.0 ; t += DT ) {
    printf("%f   %f %f %f %f    %f %f %f %f\n", t, 
	   modelX[0], modelX[1], modelX[2], modelX[3],
	   modelXe[0], modelXe[1], modelXe[2], modelXe[3]
	   );

    update_Kalman_filter();     // recompute the state estimate
    update_LQR_control();       // compute the control based on the state estimate
    update_linear_simulation(); // compute the new simulated state based on the control
    // printf("\n");
  }
  return 0;
}
