// serial-robot-interface.c : communicate with the Balancer over a serial port
// This file is part of ArtLPC. 
// This file is placed into the public domain.

// This should always reflect the actual configuration of the robot.

#include <libstd.h>
#include <libLPC2xxx.h>
#include <posix_serial_port.h>
#include <string_port.h>
#include <errcodes.h>

/****************************************************************/
// for my G5:
// #define SERIAL_PORT "/dev/cu.USA19QWb13P1.1"

// for my laptop, using the rearward serial port
#define SERIAL_PORT "/dev/cu.USA19QW1b1P1.1"

// For the brain boxes BL-819 Bluetooth dongle to my laptop.
// However, the Bluetooth latency is too high to use in a control
// loop.
// #define SERIAL_PORT "/dev/cu.Manicotti-Serial01-1"

static FILE *serial_sensor_in, *serial_command_out;

/****************************************************************/
// returns true on error, including a broken connection
static int wait_for_sensor_data(void)
{
#define MAXSENSORLENGTH 200
  char linebuf[MAXSENSORLENGTH+1];
  int i, c;
  int numargs;

 try_again:

  // first read a line of ASCII sensor data, ignoring overruns
  for( i = 0 ; ; ) {
    c = fgetc( serial_sensor_in );
    if ( c == EOF ) return -2;
    else if ( c == '\n' ) break;
    else if ( i < MAXSENSORLENGTH ) linebuf[i++] = c;
  }
  linebuf[i] = 0;

  // if the line begins with '#', it is debugging output
  if (linebuf[0] == '#') {
    printf( "DBG: %s\n", linebuf );
    goto try_again;
  }

  // parse the sensor data line
  numargs = sscanf( linebuf, "L%dR%dX%dY%dZ%dP%dQ%dT%d",
		    &q_raw.left, &q_raw.right, 
		    &qdd_raw.x, &qdd_raw.y, &qdd_raw.z, 
		    &qd_raw.pitch, &qd_raw.yaw,
		    &q_raw.tilt );

  if ( numargs != 8 ) {
    printf("only %d args received, ignoring line '%s'.\n", numargs, linebuf);
    goto try_again;
  }

  return 0;
}
#undef MAXSENSORLENGTH

/****************************************************************/
void send_commanded_torque_to_robot(void)
{
  // Compute the raw command value from the calibrated value.  For the
  // time being, the motor is simply commanded over [-1.0, 1.0].  The
  // nominal stall torque of the Pittman 9234S007 motors is 0.29N-m,
  // which is multiplied by two by the drive reduction.  But the
  // actual torque delivered depends upon the speed, since the
  // Sabertooth driver is probably not doing actual current control.

  tau_raw.left  = (int) (tau.left  * 127.0);
  tau_raw.right = (int) (tau.right * 127.0);

  // limit the command values to the ranges of the driver
  if (tau_raw.left < -127) tau_raw.left = -127;
  else if (tau_raw.left > 127) tau_raw.left = 127;
  if (tau_raw.right < -127) tau_raw.right = -127;
  else if (tau_raw.right > 127) tau_raw.right = 127;

  // send a command packet
  fprintf( serial_command_out, "L%dR%d\n", tau_raw.left, tau_raw.right);
  fflush( serial_command_out );
}
/****************************************************************/
