/****************************************************************/
// structures for raw sensor data
struct q_raw_t {
  int left, right;  // wheel encoders
  int tilt;         // body tilt encoder
} q_raw;

struct qd_raw_t {
  int pitch, yaw;
} qd_raw;

struct qdd_raw_t {
  int x, y, z;
} qdd_raw;

// structure for raw command values
struct tau_raw_t {
  int left, right;
} tau_raw;

// structures for calibrated and estimated sensor data
struct q_t {
  float left, right, tilt;
} q;

struct qd_t {
  float left, right;   // derivative of wheel encoders
  float pitch, yaw;    // rate gyros
  float tilt;          // derivative of body tilt encoder
} qd;

struct qdd_t {
  float x, y, z;
} qdd;

// structure for calibrated command values
struct tau_t {
  float left, right;
} tau;

/****************************************************************/
