// matrices.c : basic matrix operations
// This file is part of ArtLPC. 
// This file is placed into the public domain.

// Simple matrix operations using float arrays.  All matrices are
// stored in row-major order, and the dimensions explicitly provided.

/****************************************************************/
// Ah, how many times has this been written in the history of
// computing?  And usually more efficiently.  But this is
// self-contained.

// As always, the sizes must be compatible:
//     result +=    M1   *     M2
//    [a X c ] = [a X b] * [ b X c ]
   
void matrix_multiply_sum( float *m1, float *m2, float *result,
			  int a, int b, int c )
{
  int i, j, k;

  for (i = 0; i < a; i++) {  // index rows of the result
    for (j = 0; j < c; j++) {  // index columns of the result
      // take the dot product of a m1 row and a m2 column
      float sum = 0.0;
      for (k = 0; k < b; k++) sum += m1[ i*b + k] * m2[ k*c + j];
      result[ i*c + j ] += sum;
    }
  }
}
/****************************************************************/
void matrix_zero( float *m, int elements )
{
  while (elements-- > 0) *m++ = 0.0;
}

void matrix_copy( float *src, float *dst, int elements )
{
  while (elements-- > 0) *dst++ = *src++;
}

/****************************************************************/
