// encoder_counter.h : definitions for a two channel quadrature encoder interface
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------

// This version just counts the position in software.  This might be
// extended in the future to use the timer input captures to precisely
// estimate the edge transition times and yield a better velocity
// estimate at low speeds.

#ifndef ENCODER_COUNTER_H_INCLUDED
#define ENCODER_COUNTER_H_INCLUDED

#include <libLPC2xxx.h>
#include <libstd.h>

/****************************************************************/
// Define masks for the GPIO0 pins in use by the encoder inputs.
// All mask numbers N correspond to pin P0.N.

#define MOT1APIN   GPIO_PIN_MASK(10)
#define MOT1BPIN   GPIO_PIN_MASK(11)
#define MOT1IPIN   GPIO_PIN_MASK(19)

#define MOT2APIN   GPIO_PIN_MASK(17)
#define MOT2BPIN   GPIO_PIN_MASK(18)
#define MOT2IPIN   GPIO_PIN_MASK(20)

#if CONFIG_ENCODER_ON_EXPANSION
#define EXTRAAPIN   GPIO_PIN_MASK(16)
#define EXTRABPIN   GPIO_PIN_MASK(13)
#define EXTRAIPIN   GPIO_PIN_MASK(21)
#endif

/****************************************************************/
// Global state structure for each encoder; some values are updated
// during timer interrupt processing.

extern struct encoder_t {
  volatile int position;           // motor shaft position, in encoder phase units
  volatile int last_step;
  volatile unsigned last_phase;

  // constant bit masks for hardware I/O configuration
  unsigned ABI_mask, A_mask, B_mask, I_mask; 

} encoder1, encoder2;

#if CONFIG_ENCODER_ON_EXPANSION
extern struct encoder_t extra_encoder;
#endif

// Interrupt update function.
extern void encoder_counter_poll(void);

// API functions.
extern int init_encoder_counter(void);

/****************************************************************/
#endif // ENCODER_COUNTER_H_INCLUDED
