% Runs the specified clustering algorithm and calculates time elapsed,
% where A is the affinity matrix, k is the number of clusters, and alg is
% the algorithm name
%
% Author: Frank Lin (frank@cs.cmu.edu)

function [E,preptime,embedtime,it]=x_clusterembed_icml2010(A,k,alg)

baseconv=0.001;
n=size(A,1);
preptime=0;
embedtime=0;
it=0;

if strcmp(alg,'kmeans')||strcmp(alg,'none')
    
    E=A;
    
elseif strcmp(alg,'pic')
    
    tic;
    W=normrow(A);
    v0=stationary(A);
    preptime=toc;
    
    tic;
    [E,it]=pic(W,v0,baseconv/n,5000);
    embedtime=toc;
    
elseif strcmp(alg,'pic-r')
    
    tic;
    W=normrow(A);
    v0=rand(n,1);
    preptime=toc;
    
    tic;
    [E,it]=pic(W,v0,baseconv/n,5000);
    embedtime=toc;
    
elseif strcmp(alg,'pic-r2')
    
    tic;
    W=normrow(A);
    preptime=toc;
    
    E=zeros(n,2);
    for i=1:2
        
        tic;
        v0=rand(n,1);
        preptime=preptime+toc;
    
        tic;
        [E(:,i),it]=pic(W,v0,baseconv/n,5000);
        embedtime=embedtime+toc;
        
    end

elseif strcmp(alg,'ncut-evd')
    
    tic;
    W=normlaprw(full(A));
    preptime=toc;
    
    tic;
    [E,V]=eig(W);
    [~,index]=sort(diag(V));
    E=E(:,index);
    E=E(:,2:k);
    embedtime=toc;
    
elseif strcmp(alg,'ncut-evd-v10')
    
    tic;
    W=normlaprw(full(A));
    preptime=toc;
    
    tic;
    [E,V]=eig(W);
    [~,index]=sort(diag(V));
    E=E(:,index);
    E=E(:,2:10);
    embedtime=toc;
    
elseif strcmp(alg,'ncut-evd-v10-lambda')
    
    tic;
    W=normlaprw(full(A));
    preptime=toc;
    
    tic;
    [E,V]=eig(W);
    V=eye(size(V))-V;
    E=E*V;
    [~,index]=sort(diag(V),1,'descend');
    E=E(:,index);
    E=E(:,2:10);
    embedtime=toc;
    
elseif strcmp(alg,'ncut-evd-v10-lambda15')
    
    tic;
    W=normlaprw(full(A));
    preptime=toc;
    
    tic;
    [E,V]=eig(W);
    V=eye(size(V))-V;
    V=V^15;
    E=E*V;
    [~,index]=sort(diag(V),1,'descend');
    E=E(:,index);
    E=E(:,2:10);
    embedtime=toc;
    
elseif strcmp(alg,'ncut-iram')
    
    tic;
    W=normlaprw(A);
    preptime=toc;
    
    tic;
    opts.disp=0;
    [E,~]=eigs(W,k,'SM',opts);
    E=E(:,2:k);
    embedtime=toc;
    
elseif(strcmp(alg,'njw-evd'))
    
    tic;
    W=normlapsym(full(A));
    preptime=toc;
    
    tic;
    [E,V]=eig(W);
    [~,index]=sort(diag(V));
    E=E(:,index);
    E=E(:,1:k);
    embedtime=toc;
    
elseif(strcmp(alg,'njw-iram'))
    
    tic;
    W=normlapsym(A);
    preptime=toc;
    
    tic;
    opts.disp=0;
    [E,~]=eigs(W,k,'SM',opts);
    embedtime=toc;
    
else
    
    fprintf('algorithm not recognized: %s\n',alg);
    
end

fprintf('prepping time for %s: %f ms\n',alg,preptime*1000);
fprintf('embedding time for %s: %f ms\n',alg,embedtime*1000);

end