% Runs all clustering experiments on real datasets and show accuracy
% results
%
% Author: Frank Lin (frank@cs.cmu.edu)

algs={'ncut-evd','njw-evd','pic','ncut-evd-v10','ncut-evd-v10-lambda','ncut-evd-v10-lambda15'};
results=cell(size(algs));

for i=1:length(algs)
    
    r=zeros(10,3);
    
    [r(1,1),r(1,2),r(1,3)]=x_cluster_icml2010(iris,3,algs{i},100,iris_label);
    [r(2,1),r(2,2),r(2,3)]=x_cluster_icml2010(pendigits01,2,algs{i},100,pendigits01_label);
    [r(3,1),r(3,2),r(3,3)]=x_cluster_icml2010(pendigits17,2,algs{i},100,pendigits17_label);
    [r(4,1),r(4,2),r(4,3)]=x_cluster_icml2010(polbooks,3,algs{i},100,polbooks_label);
    [r(5,1),r(5,2),r(5,3)]=x_cluster_icml2010(umbcblog,2,algs{i},100,umbcblog_label);
    [r(6,1),r(6,2),r(6,3)]=x_cluster_icml2010(agblog,2,algs{i},100,agblog_label);
    [r(7,1),r(7,2),r(7,3)]=x_cluster_icml2010(X20ngA,2,algs{i},100,X20ngA_label);
    [r(8,1),r(8,2),r(8,3)]=x_cluster_icml2010(X20ngB,2,algs{i},100,X20ngB_label);
    [r(9,1),r(9,2),r(9,3)]=x_cluster_icml2010(X20ngC,3,algs{i},100,X20ngC_label);
    [r(10,1),r(10,2),r(10,3)]=x_cluster_icml2010(X20ngD,4,algs{i},100,X20ngD_label);
    
    results{i}=r;
    
end

for i=1:length(algs)
   
    fprintf('results for %s:\n',algs{i});
    disp('    Purity      NMI       RI');
    disp(results{i});
    
end