% Runs a clustering experiment
%
% Author: Frank Lin (frank@cs.cmu.edu)

function [purity,nmi,rand,preptime,embedtime,kmeanstime,it]=x_cluster_icml2010(data,k,alg,kmtrials,truth)

fprintf('embedding data points...\n');
[E,preptime,embedtime,it]=x_clusterembed_icml2010(data,k,alg);

fprintf('running k-means...\n');
tic;
pred=kmeans_freq(E,k,kmtrials,'m');
kmeanstime=toc;
fprintf('k-means time: %f ms\n',kmeanstime*1000);

fprintf('evaluating results...\n');
tic;
purity=eval_acc_purity(truth,pred);
nmi=eval_nmi(truth,pred);
rand=eval_rand(truth,pred);
evaltime=toc;
fprintf('evaluation time: %f ms\n',evaltime*1000);

fprintf('purity: %f\n',purity);
fprintf('nmi:    %f\n',nmi);
fprintf('rand:   %f\n',rand);

end