% Runs the specified clustering algorithm and calculates time elapsed,
% where A is the affinity matrix, k is the number of clusters, and alg is
% the algorithm name, and simfun is the similarity function name
%
% Author: Frank Lin (frank@cs.cmu.edu)

function [E,preptime,embedtime,it]=x_clusterembed(A,k,alg)

baseconv=0.00001;
n=size(A,1);
preptime=0;
embedtime=0;
it=0;

if strcmp(alg,'kmeans')||strcmp(alg,'none')
    E=A;
elseif strcmp(alg,'pic')
    
    tic;
    W=normrow(A);
    v0=stationary(A);
    preptime=toc;
    
    tic;
    [E,it]=pic(W,v0,baseconv/n,5000);
    embedtime=toc;
    
elseif strcmp(alg,'pic-p')
    
    tic;
    W=normrow(A);
    v0=stationary(A);
    preptime=toc;
    
    tic;
    [E,it]=pic(W,v0,baseconv/n/100,5000);
    embedtime=toc;
    
elseif strcmp(alg,'pic-r')
    
    tic;
    W=normrow(A);
    v0=rand(n,1);
    preptime=toc;
    
    tic;
    [E,it]=pic(W,v0,baseconv/n,5000);
    embedtime=toc;
    
elseif strcmp(alg,'pic-r2')
    
    tic;
    W=normrow(A);
    preptime=toc;
    
    E=zeros(n,2);
    for i=1:2
        
        tic;
        v0=rand(n,1);
        preptime=preptime+toc;
    
        tic;
        [E(:,i),it]=pic(W,v0,baseconv/n,5000);
        embedtime=embedtime+toc;
        
    end
    
elseif strcmp(alg,'pic-r3')
    
    tic;
    W=normrow(A);
    preptime=toc;
    
    E=zeros(n,3);
    for i=1:3
        
        tic;
        v0=rand(n,1);
        preptime=preptime+toc;
    
        tic;
        [E(:,i),it]=pic(W,v0,baseconv/n,5000);
        embedtime=embedtime+toc;
        
    end
    
elseif strcmp(alg,'pic-r4')
    
    tic;
    W=normrow(A);
    preptime=toc;
    
    E=zeros(n,4);
    for i=1:4
        
        tic;
        v0=rand(n,1);
        preptime=preptime+toc;
    
        tic;
        [E(:,i),it]=pic(W,v0,baseconv/n,5000);
        embedtime=embedtime+toc;
        
    end
    
elseif strcmp(alg,'pic-r10')
    
    tic;
    W=normrow(A);
    preptime=toc;
    
    E=zeros(n,10);
    for i=1:10
        
        tic;
        v0=rand(n,1);
        preptime=preptime+toc;
    
        tic;
        [E(:,i),it]=pic(W,v0,baseconv/n,5000);
        embedtime=embedtime+toc;
        
    end
    
elseif strcmp(alg,'pic-r20p')
    
    tic;
    W=normrow(A);
    preptime=toc;
    
    E=zeros(n,20);
    for i=1:20
        
        tic;
        v0=rand(n,1);
        preptime=preptime+toc;
    
        tic;
        [E(:,i),it]=pic(W,v0,baseconv/n/100,5000);
        embedtime=embedtime+toc;
        
    end
    
elseif strcmp(alg,'pic-rp')
    
    tic;
    W=normrow(A);
    v0=rand(n,1);
    preptime=toc;
    
    tic;
    [E,it]=pic(W,v0,baseconv/n/100,5000);
    embedtime=toc;
    
elseif strcmp(alg,'pic_inner')
    
    tic;
    N=prep_inner(A);
    v0=stationary_inner(A);
    preptime=toc;
    
    tic;
    [E,it]=pic_kernel(A,v0,baseconv/n,5000,'inner',{N});
    embedtime=toc;
    
elseif strcmp(alg,'pic_inner-p')
    
    tic;
    N=prep_inner(A);
    v0=stationary_inner(A);
    preptime=toc;
    
    tic;
    [E,it]=pic_kernel(A,v0,baseconv/n/100,5000,'inner',{N});
    embedtime=toc;
    
elseif strcmp(alg,'pic_inner-r')
    
    tic;
    N=prep_inner(A);
    v0=rand(n,1);
    preptime=toc;
    
    tic;
    [E,it]=pic_kernel(A,v0,baseconv/n,5000,'inner',{N});
    embedtime=toc;

elseif strcmp(alg,'pic_inner-rp')
    
    tic;
    N=prep_inner(A);
    v0=rand(n,1);
    preptime=toc;
    
    tic;
    [E,it]=pic_kernel(A,v0,baseconv/n/100,5000,'inner',{N});
    embedtime=toc;
    
elseif strcmp(alg,'pic_cos')

    tic;
    [N,D]=prep_cos(A);
    v0=stationary_cos(A,D);
    preptime=toc;
    
    tic;
    [E,it]=pic_kernel(A,v0,baseconv/n,5000,'cos',{N,D});
    embedtime=toc;
    
elseif strcmp(alg,'pic_cos-p')

    tic;
    [N,D]=prep_cos(A);
    v0=stationary_cos(A,D);
    preptime=toc;
    
    tic;
    [E,it]=pic_kernel(A,v0,baseconv/n/100,5000,'cos',{N,D});
    embedtime=toc;
 
elseif strcmp(alg,'pic_cos-r')

    tic;
    [N,D]=prep_cos(A);
    v0=rand(n,1);
    preptime=toc;
    
    tic;
    [E,it]=pic_kernel(A,v0,baseconv/n,5000,'cos',{N,D});
    embedtime=toc;

elseif strcmp(alg,'pic_cos-rp')

    tic;
    [N,D]=prep_cos(A);
    v0=rand(n,1);
    preptime=toc;
    
    tic;
    [E,it]=pic_kernel(A,v0,baseconv/n/100,5000,'cos',{N,D});
    embedtime=toc;

elseif strcmp(alg,'ncut-evd')
    
    tic;
    W=normlaprw(A);
    preptime=toc;
    
    tic;
    [E,~]=eig(W);
    E=E(:,2:k);
    embedtime=toc;
    
elseif strcmp(alg,'ncut-iram')
    
    tic;
    W=normlaprw(A);
    preptime=toc;
    
    tic;
    opts.disp=0;
    [E,~]=eigs(W,k,'SM',opts);
    E=E(:,2:k);
    embedtime=toc;
    
elseif(strcmp(alg,'njw-evd'))
    
    tic;
    W=normlapsym(A);
    preptime=toc;
    
    tic;
    [E,~]=eig(W);
    E=E(:,1:k);
    embedtime=toc;
    
elseif(strcmp(alg,'njw-iram'))
    
    tic;
    W=normlapsym(A);
    preptime=toc;
    
    tic;
    opts.disp=0;
    [E,~]=eigs(W,k,'SM',opts);
    embedtime=toc;
    
else
    fprintf('does not recognize algorithm: %s\n',alg);
end

fprintf('prepping time for %s: %f ms\n',alg,preptime*1000);
fprintf('embedding time for %s: %f ms\n',alg,embedtime*1000);

end