% Runs a series of clustering experiments given the data collection, the
% labels for the data collection, the algorithm, the similarity function,
% the number of k-means trials, and the list of categories that specifies
% the datasets for the experiments.
%
% Author: Frank Lin (frank@cs.cmu.edu)

function [accs,nmis,preptimes,embedtimes,kmeanstimes,its]=x_cluster_pairs(features,labels,alg,sim,catslist,kmtrials)

n=size(catslist,1);
accs=zeros(n,1);
nmis=zeros(n,1);
preptimes=zeros(n,1);
embedtimes=zeros(n,1);
kmeanstimes=zeros(n,1);
its=zeros(n,1);

for i=1:n
    fprintf('running %s with %s on pair %d...\n',alg,sim,i);
    [accs(i),nmis(i),preptimes(i),embedtimes(i),kmeanstimes(i),its(i)]=x_cluster_cat(features,labels,catslist(i,:),alg,sim,kmtrials);
end

end