% Runs clustering experiments found in:
%
% A Very Fast Method for Clustering Big Text Datasets,
% Frank Lin and William W. Cohen. ECAI 2010, Lisbon, Portugal.
%
% Author: Frank Lin (frank@cs.cmu.edu)

algs={'kmeans','pic_cos-r','ncut-iram','ncut-evd'};
sims={'','','cos','cos'};

results=cell(size(algs));

for i=1:length(algs)
   
    r=zeros(size(pairs_ecai2010,1),4);
    [r(:,1),r(:,2),~,r(:,3),~,r(:,4)]=x_cluster_pairs(feature,label,algs{i},sims{i},pairs_ecai2010,10);
    results{i}=r;
    
end

for i=1:length(algs)
   
    fprintf('results for %s with %s similarity:\n',algs{i},sims{i});
    disp('  Accuracy      NMI      Time  Iterations');
    disp(results{i});
    disp('averages:');
    disp(mean(results{i}));
    
end