% Runs a clustering experiment given the data collection, the labels for
% the data collection, the categories that make up this dataset
% for the experiment, the algorithm, the similarity function, and the
% number of k-means trials to run.
%
% Author: Frank Lin (frank@cs.cmu.edu)

function [acc,nmi,preptime,embedtime,kmeanstime,it]=x_cluster_cat(features,labels,cats,alg,simfun,kmtrials)

[F,L]=x_subdataset(features,labels,cats);

if strncmp(alg,'pic_',4)||strcmp(alg,'kmeans')
    fprintf('running: %s\n',alg);
    [acc,nmi,preptime,embedtime,kmeanstime,it]=x_cluster(F,length(cats),alg,kmtrials,L);
else
    fprintf('running: %s\n',simfun);
    if strcmp(simfun,'dot')
        F=F*F';
    elseif strcmp(simfun,'cos')
        F=cossim(F,true);
    end
    if strcmp(alg,'ncut-evd')||strcmp(alg,'njw-evd')
        F=full(F);
    end
    fprintf('running: %s\n',alg);
    [acc,nmi,preptime,embedtime,kmeanstime,it]=x_cluster(F,length(cats),alg,kmtrials,L);
end

end