% Author: Frank Lin (frank@cs.cmu.edu)

function [acc,nmi,preptime,embedtime,kmeanstime,it]=x_cluster(A,k,alg,kmtrials,truth)

fprintf('embedding data points...\n');
[E,preptime,embedtime,it]=x_clusterembed(A,k,alg);

fprintf('running k-means...\n');
tic;
pred=kmeans_wcss(E,k,kmtrials,'cl');
kmeanstime=toc;
fprintf('k-means time: %f ms\n',kmeanstime*1000);

fprintf('evaluating results...\n');
tic;
acc=eval_acc_hung(truth,pred);
nmi=eval_nmi(truth,pred);
evaltime=toc;
fprintf('evaluation time: %f ms\n',evaltime*1000);

fprintf('acc: %f\n',acc);
fprintf('nmi: %f\n',nmi);

end