% Returns the stationary distribution v of an affinity matrix A as if the
% rows of A were normalized as a markov transition matrix.
%
% Author: Frank Lin (frank@cs.cmu.edu)

function v=stationary(A)

D=degree(A);
volume=sum(sum(D));
v=zeros(size(D,1),1);
for i=1:size(v)
    v(i)=D(i,i)/volume;
end

end