% Prepares the stochastic normalizing matrix for "path trick" (inner product kernel).
% The output is sparse.
%
% Decomposition of a row-stochastic matrix W:
% W=N*M*M'
%
% Author: Frank Lin (frank@cs.cmu.edu)

function N=prep_inner(M)

n=size(M,1);

% get 1/degree
d=(M*(M'*ones(n,1))).^-1;
% make sure no infinity
d(isinf(d))=0;
% put on diagonal matrix
N=spdiags(d,0,n,n);

end