% Prepares the stochastic normalizing matrix and vector length normalizer
% matrix for cosine similarity kernel.
% Output is sparse.
%
% Decomposition of a row-stochastic matrix:
% W=N*L*M*M'*L

function [N,L]=prep_cos(M)

n=size(M,1);

% vector length normalizer
l=dot(M,M,2).^-(1/2);
l(isinf(l))=0;
L=spdiags(l,0,n,n);

% get 1/degree
d=(L*(M*(M'*(L*ones(n,1))))).^-1;
% make sure no infinity
d(isinf(d))=0;
% put on diagonal matrix
N=spdiags(d,0,n,n);

end