% Returns a "random walks" normalized Laplacian matrix N of W like the one
% used in Normalized Cuts. If W is sparse N will be sparse.
%
% Author: Frank Lin (frank@cs.cmu.edu)

function N=normlaprw(W)

Dinv=degree(W);
n=size(Dinv,1);

for i=1:n
  Dinv(i,i)=1/Dinv(i,i);
end

N=Dinv*laplacian(W);

end