% Cosine normalization: normalizes row-instance feature vectors in a matrix
% to have unit length 1
%
% Author: Frank Lin (frank@cs.cmu.edu)

function Fcs=normcos(F)

% calculate vector length normalizer matrix
n=size(F,1);
d=sum(F.*F,2).^(-1/2);
d(isinf(d))=0;
N=spdiags(d,0,n,n);

Fcs=N*F;

end