% Creates a cosine-normalized similarity matrix from data
%
% Input:
% F - row-instance feature matrix
% zdiag - whether to zero the diagonal (no self-similarity)
%
% Output:
% S - cosine-normalized similarity matrix
%
% Author: Frank Lin (frank@cs.cmu.edu)


function S=cossim(F,zdiag)

% slow way that uses the matlab pdist function
% S=1-squareform(pdist(F,'cosine'));

% fast way using matrix operations
n=size(F,1);
S=F*F';
D=sparse(n,n);
for i=1:n
    D(i,i)=1/sqrt(S(i,i));
end
S=D*S*D;

if(zdiag)
    S=S-speye(n);
end

end