% Runs SSL experiments found in:
%
% Semi-Supervised Classification of Network Data Using Very Few Labels,
% Frank Lin and William W. Cohen. ASONAM 2010, Odense, Denmark.
%
% Author: Frank Lin (frank@cs.cmu.edu)

algs={'wvrn','wvrn100','mrw05'};
%algs={'mrw05','mrw15','mrw25','mrw35'};
seedalgs={'rand-stratmin','highdegree-stratmin','highpagerank-stratmin'};
seedps=[1,2,5,10,20,40];

results=cell(length(seedalgs),length(algs));

for i=1:length(seedalgs)
    runs=1;
    if strncmp(seedalgs{i},'rand',4)
        runs=20;
    end
    for j=1:length(algs)
        r=zeros(5,length(seedps),runs);
        for k=1:length(seedps)
            for l=1:runs
                fprintf('experimenting %s p=%d with %s run %d\n',seedalgs{i},seedps(k),algs{j},l);
                
                L=x_seed(umbcblog_label,umbcblog,seedalgs{i},seedps(k));
                [~,~,~,r(1,k,l)]=x_ssl_asonam2010(umbcblog,L,umbcblog_label,algs{j});
                
                L=x_seed(agblog_label,agblog,seedalgs{i},seedps(k));
                [~,~,~,r(2,k,l)]=x_ssl_asonam2010(agblog,L,agblog_label,algs{j});
                
                L=x_seed(mspblog_label,mspblog,seedalgs{i},seedps(k));
                [~,~,~,r(3,k,l)]=x_ssl_asonam2010(mspblog,L,mspblog_label,algs{j});
                
                L=x_seed(cora_label,cora,seedalgs{i},seedps(k));
                [~,~,~,r(4,k,l)]=x_ssl_asonam2010(cora,L,cora_label,algs{j});
                
                L=x_seed(citeseer_label,citeseer,seedalgs{i},seedps(k));
                [~,~,~,r(5,k,l)]=x_ssl_asonam2010(citeseer,L,citeseer_label,algs{j});
            end
        end
        results{i,j}=mean(r,3);
    end
end

for i=1:length(seedalgs)
    for j=1:length(algs)
        
        fprintf('results for %s using %s seeding (row=dataset, col=#seeds):\n',algs{j},seedalgs{i});
        disp(results{i,j});
        
    end
end