% Runs a semi-supervised learning experiment
%
% Input:
% F - row-instance feature matrix
% L - seed matrix: L(i,j)=1 means instance i is a seed for label j
% truth - ground truth vector: truth(i)=j means instance i has true label j
% alg - the name of the SSL algorithm
% useprior - whether to use training label distribution (usually not)
% kernel - the name of the similarity kernel, if any
% normalizers - cell-array of precomputed normalizers, if any
%
% Output:
% accuracy - # correct instances / # total instances
% precision - macro-averaged label precision
% recall - macro-averaged label recall
% f1 - macro-averaged F1-score
% confusion - the confusion matrix
%
% Author: Frank Lin (frank@cs.cmu.edu)

function [accuracy,precision,recall,f1,confusion]=x_ssl_asonam2010(F,L,truth,alg)

fprintf('running %s...',alg);
[X]=x_ssl_alg_asonam2010(F,L,alg);

fprintf('evaluating...');
% get label prediction from output score
[~,pred]=max(X,[],2);
% only evaluate instances with ground truth labels
test=find((sum(L,2)==0).*(truth>0));
% various eval measures
accuracy=eval_acc(truth(test),pred(test));
[precision,recall,f1]=eval_prf(truth(test),pred(test));
confusion=eval_confusion(truth(test),pred(test));
fprintf('done.\n');

end