% Given the input graph, seed, and the named algorithm, returns the
% classification scores and the runtime
%
% Author: Frank Lin (frank@cs.cmu.edu)

function [X]=x_ssl_alg_asonam2010(M,L,alg)

n=size(M,1);
conv=0.001;

switch alg
    case 'random' % uniformly random
        X=x_label_expand(randi(size(L,2),size(L,1),1));
    case 'wvrn' % wvRN / harmonic functions method
        [X,~]=harmonic(normcol(M),L,conv,500,false);
    case 'wvrn100' % wvRN / harmonic functions using 100 iterations
        [X,~]=harmonic(normcol(M),L,0,100,false);
    case 'mrw05' % mrw w/ 0.05 restart prob. (0.95 damping factor)
        [X,~]=mrw(normrow(M),L,0.05,0,conv/n,500,false);
    case 'mrw15' % mrw w/ 0.15 restart prob. (0.85 damping factor)
        [X,~]=mrw(normrow(M),L,0.15,0,conv/n,500,false);
    case 'mrw25' % mrw w/ 0.25 restart prob. (0.75 damping factor)
        [X,~]=mrw(normrow(M),L,0.25,0,conv/n,500,false);
    case 'mrw35' % mrw w/ 0.35 restart prob. (0.65 damping factor)
        [X,~]=mrw(normrow(M),L,0.35,0,conv/n,500,false);
    otherwise
        fprintf('does not recognize algorithm: %s\n',alg);
        X=L;
end

end