% MultiRankWalk
%
% Input:
% P - a column-normalized transition matrix
% L - row-instance seed labels (1 or 0)
% rprob - restart probability
% tprob - teleportation probability
% conv - convergence threshold
% maxit - maximum number of iterations
% pmass - whether or not to adjust probability mass according to class
% priors estimated from seed labels
%
% Output:
% X - row-instance predicted soft labels
% i - iterations ran
%
% Author: Frank Lin (frank@cs.cmu.edu)

function [X,i]=mrw(P,L,rprob,tprob,conv,maxit,pmass)

n=size(L,1);

% initial vectors
X0=normcol(L);

% restart vectors
R=rprob*X0;

% for iterations
Xp=zeros(size(L));
X=X0;

i=0;
while(max(max(abs(X-Xp)))>conv&&i<maxit) 
    % save previous
    Xp=X;
    % walk
    X=(1-rprob-tprob)*(P*X)+R+(tprob/n);
    % normalize
    X=normcol(X);
    % increment counter
    i=i+1;
end

if pmass
    X=X*diag(sum(L));
end

end
