% Calculates accuracy and macro-averaged precision, recall, and F1 score
% 
% Author: Frank Lin (frank@cs.cmu.edu)

function [precision,recall,f1]=eval_prf(truth,pred)

classes=unique(truth);

psum=0;
rsum=0;
f1sum=0;

for i=1:length(classes)
    tp=sum((truth==classes(i)).*(pred==classes(i))==1);
    p=sum(pred==classes(i));
    t=sum(truth==classes(i));
    prec=tp/p;
    prec(isnan(prec))=0;
    rec=tp/t;
    rec(isnan(rec))=0;
    f1=2*prec*rec/(prec+rec);
    f1(isnan(f1))=0;
    psum=psum+prec;
    rsum=rsum+rec;
    f1sum=f1sum+f1;
end

precision=psum/length(classes);
recall=rsum/length(classes);
f1=f1sum/length(classes);

end