;;; mpass major mode for syntax highlighting only
;;;
;;; Add
;;;
;;; (setq mpass-root "/Users/fp/courses/15836-f23/repo/f23/assignments/asst3/src/")
;;; (load (concat mpass-root "mpass.el"))
;;; (setq auto-mode-alist (cons '("\\.mps$" . mps-mode) auto-mode-alist))
;;;
;;; to your .emacs or Preferences.el file

(defvar mpass-mode-syntax-table nil "syntax table for `mpass-mode'.")

(setq mpass-mode-syntax-table
      (let ((synTable (make-syntax-table)))
        (modify-syntax-entry ?\( "()1" synTable)
        (modify-syntax-entry ?\) ")(4" synTable)
        (modify-syntax-entry ?{ "(}" synTable)
        (modify-syntax-entry ?} "){" synTable)
        (modify-syntax-entry ?* ". 23n" synTable)
        (modify-syntax-entry ?' "w" synTable) ;; purposely, to simplify patterns
        (modify-syntax-entry ?: "." synTable)
        (modify-syntax-entry ?, "." synTable)
        (modify-syntax-entry ?. "." synTable)
        ; (modify-syntax-entry ?! "." synTable)
        ; (modify-syntax-entry ?? "." synTable)
        (modify-syntax-entry ?+ "." synTable)
        (modify-syntax-entry ?& "." synTable)
        ; (modify-syntax-entry ?< "." synTable)
        ; (modify-syntax-entry ?> "." synTable)
        (modify-syntax-entry ?- "." synTable)
        (modify-syntax-entry ?= "." synTable)
        ; (modify-syntax-entry ?/ "." synTable)
        ; (modify-syntax-entry ?\\ "." synTable) ;; for conjunction /\
        (modify-syntax-entry ?% "<" synTable)
        (modify-syntax-entry ?\n ">" synTable)
        (modify-syntax-entry ?_ "w" synTable) ;; purposely, to simplify patterns
        synTable))

;; currently not used
(defun all-type-names-regexp (limit)
  (let ((type-names nil))
    (while (re-search-forward "\\<\\(type\\)\\>\\s-+\\<\\(\\w+\\)\\>" limit t)
      (let ((type-name (match-string 2)))
        (setq type-names (cons type-name type-names))))
    (let ((type-names-regexp (concat "\\<\\(" (string-join fun-names "\\|") "\\)\\>")))
      type-names-regexp)))

(setq mpass-highlights
      '(("\\<\\(type\\|proc\\|exec\\|send\\|recv\\|fwd\\|call\\)\\>" . 'font-lock-keyword-face)
        ("\\(\\<'\\w+\\>\\|\\<'\\W\\)" . 'font-lock-constant-face)
        ("\\<\\(type\\)\\>\\s-+\\<\\(\\w+\\)\\>" 2 'font-lock-function-name-face)
        ("\\<\\(proc\\)\\>\\s-+\\<\\(\\w+\\)\\>" 2 'font-lock-function-name-face)
        ("\\<fail\\>" . 'font-lock-warning-face)))

(define-derived-mode mpass-mode fundamental-mode "mpass"
  "major mode for editing mpasste code"
  (setq font-lock-defaults '(mpass-highlights))
  (set-syntax-table mpass-mode-syntax-table))

(provide 'mpass-mode)
