(* Assignment 3 *)
(* 15-836 Fall 2023 *)
(* solution template *)

(************)
(* booleans *)
(************)

type bool = +{ 'false : 1, 'true : 1 }

(* define each of the following processes on booleans *)
(* a, b are inputs, c the output *)

proc not (c : bool) (a : bool) =
proc and (c : bool) (a : bool) (b : bool) =
proc or (c : bool) (a : bool) (b : bool) =

(******************)
(* binary numbers *)
(******************)

(*
 * least significant bit sent first
 * 3 = e11 and 4 = e100
 * there should be no leading 0s, so e011 or e00100 are not allowed
 *)

type bin = +{ 'e : 1, 'b0 : bin, 'b1 : bin }

(* from lecture *)
proc zero (x:bin) = send x 'e ; send x ()
proc succ (y:bin) (x:bin) =
  recv x ( 'e => recv x ( () => send y 'b1 ; send y 'e ; send y ())
         | 'b0 => send y 'b1 ; fwd y x
         | 'b1 => send y 'b0 ; call succ y x )

(* define the predecessor, where predecessor of zero is zero *)
(* may assume x does not have leading 0s *)
(* must ensure that y does not have leading 0s *)

proc pred (y:bin) (x:bin) =

(***************************)
(* lists of binary numbers *)
(***************************)

type list = +{ 'nil : 1, 'cons : bin * list }

(* from lecture *)
proc nil (r : list) = send r 'nil ; send r ()
proc cons (r : list) (x : bin) (l : list) =
  send r 'cons ; send r x ; fwd r l

proc append (r : list) (l : list) (k : list) =
  recv l ('nil => recv l (() => fwd r k)
         |'cons => recv l (x => send r 'cons ; send r x ;
                                call append r l k))

(* define reverse, where r should be the reverse of l *)

proc reverse (r : list) (l : list) =

(*************)
(* iteration *)
(*************)

(* we cannot define the usual functional
 * map (f : A -> B) (l : list A) : list B
 * because f may be used many times, including zero if l is empty,
 * but we can replace multiple uses of f with iteration
 *)
type iterator = &{ 'next : bin -o (bin * iterator) , 'done : 1 }

(* define map, which applies the iterator to every element in l in order *)

proc map (r : list) (iter : iterator) (l : list) =

(* define isucc, the iterator that increments each element *)

proc isucc (i : iterator) =


(**********)
(* queues *)
(**********)

type store = &{ 'ins : bin -o store,
                'del : +{ 'none : 1, 'some : bin * store } }

(* implement the empty queue *)
proc empty_queue (s : store) =

(* implement a node in the queue *)
proc node_queue (s : store) (x : bin) (t : store) =

(* mentioned in lecture, may help you test *)
proc store2list (l : list) (s : store) =
     send s 'del ;
     recv s ( 'none => recv s (() => send l 'nil ; send l ())
            | 'some => recv s (x => send l 'cons ; send l x ;
                                    call store2list l s) )
