(* Tests *)
(* these focus on ordered tests *)
(* run with Test.run () *)
(* raises Fail if regression testing fails *)

signature TEST =
sig

    val run : unit -> unit (* may raise Fail *)

end

structure Test :> TEST =
struct

structure O = Ordered
structure L = Linear
structure S = Structural
structure T = Trans

fun assert i test =
    (if test ()
     then print ("% test " ^ Int.toString i ^ " succeeded by returning 'true'\n")
     else ( print ("% test " ^ Int.toString i ^ " failed by returned 'false'\n") ; raise Fail "fail" ))
    handle Fail(msg) => ( print ("% test " ^ Int.toString i ^ " failed by raised an exception:\n"
                                 ^ "%% " ^ msg ^ "\n")
                        ; raise Fail "fail" )

fun deny i test =
    (if test ()
     then ( print ("% test " ^ Int.toString i ^ " failed by returning 'true'\n") ; raise Fail "fail" )
     else print ("% test " ^ Int.toString i ^ " succeeded by returning 'false'\n"))
    handle Fail(msg) => print ("% test " ^ Int.toString i ^ " succeeded by raising an exception:\n"
                               ^ "%% " ^ msg ^ "\n")

open Ordered
     
val A = Atom("A")
val B = Atom("B")
val C = Atom("C")

fun run () =
    let
        (* A . B |/- B . A *)
        val Omega1 = [Avail("ab",Fuse(A,B))]
        val A1 = Fuse(B,A)
        val M1 = FuseL("ab", Bind2("a", "b", FuseR(Id("b"), Id("a"))))

        val () = deny 1 (fn () => entails Omega1 M1 A1)
        val () = assert 1 (fn () => L.entails (T.O2L Omega1) (T.o2lp M1) (T.o2l A1))
        val () = assert 1 (fn () => S.entails (T.O2S Omega1) (T.o2sp M1) (T.o2s A1))

        (* A \ (C / B) |- (A \ C) / B *)
        val Omega2 = [Avail("acb", Under(A, Over(C, B)))]
        val A2 = Over(Under(A,C),B)
        val M2 = OverR(Bind("b",UnderR(Bind("a",UnderL("acb", Id("a"),
                   Bind("cb", OverL("cb", Id("b"), Bind("c", Id("c")))))))))

        val () = assert 2 (fn () => entails Omega2 M2 A2)
        val () = assert 2 (fn () => L.entails (T.O2L Omega2) (T.o2lp M2) (T.o2l A2))
        val () = assert 2 (fn () => S.entails (T.O2S Omega2) (T.o2sp M2) (T.o2s A2))

        (* |- A \ A *)
        val A3 = Under(A,A)
        val M3 = UnderR(Bind("a", Id("a")))
        val () = assert 3 (fn () => entails [] M3 A3)

        (* A . B |- A . B *)
        val Omega4 = [Avail("ab",Fuse(A,B))]
        val A4 = Fuse(A,B)
        val M4 = FuseL("ab", Bind2("a", "b", FuseR(Id("a"), Id("b"))))
        val () = assert 4 (fn () => entails Omega4 M4 A4)

        (* A & B |- B & A *)
        val Omega5 = [Avail("ab", With(A,B))]
        val A5 = With(B,A)
        val M5 = WithR(WithL2("ab",Bind("b",Id("b"))), WithL1("ab", Bind("a",Id("a"))))
        val () = assert 5 (fn () => entails Omega5 M5 A5)

        (* A \ (1 \ C) |- 1 \ (A \ C) *)
        val Omega6 = [Avail("ac", Under(A, Under(One, C)))]
        val A6 = Under(One, Under(A, C))
        val M6 = UnderR(Bind("o", UnderR(Bind("a",
                   OneL("o", UnderL("ac", Id("a"), Bind("oc", UnderL("oc", OneR, Bind("c", Id("c"))))))))))
        val () = assert 6 (fn () => entails Omega6 M6 A6)

        (* A \ (1 \ C) |- 1 \ (A \ C) *)
        (* with incorrect proof *)
        val M7 = UnderR(Bind("o", UnderR(Bind("a",
                   UnderL("ac", Id("a"), Bind("oc", UnderL("oc", OneR, Bind("c", Id("c")))))))))
        val () = deny 7 (fn () => entails Omega6 M7 A6)

        (* A \ (1 \ C) |- 1 \ (A \ C) *)
        (* with another incorrect proof *)
        val M8 = UnderR(Bind("o", UnderR(Bind("a",
                   UnderL("ac", Id("a"), Bind("oc", UnderL("oc", OneR, Bind("c", OneL("o", Id("c"))))))))))
        val () = deny 8 (fn () => entails Omega6 M8 A6)

        (* 1 . (A + B) |- A + B *)
        (* with incorrect proof *)
        val Omega9 = [Avail("oab", Fuse(One, Plus(A, B)))]
        val A9 = Plus(A,B)
        val M9 = FuseL("oab", Bind2("o", "ab", PlusL("ab", Bind("a", PlusR1(Id("a"))),
                   Bind("b", OneL("o", PlusR2(Id("b")))))))
        val () = deny 9 (fn () => entails Omega9 M9 A9)

        (* 1 . (A + B) |- A + B *)
        val M10 = FuseL("oab", Bind2("o", "ab", PlusL("ab", Bind("a", OneL("o", PlusR1(Id("a")))),
                    Bind("b", OneL("o", PlusR2(Id("b")))))))
        val () = assert 10 (fn () => entails Omega9 M10 A9)

    in
        ()
    end

end (* structure Test *)
