pub type Env = Vec<Defn>;

pub type Label = String;
pub type TpName = String;
pub type VarName = String;
pub type ExpName = String;
pub type ModeName = String;


#[derive(Debug, PartialEq, Eq, Clone)]
pub enum Mode {
    ModeConst(ModeName),
    ModeVar(ModeName)
}

#[derive(Debug, PartialEq, Eq, Clone)]
pub enum Type {
    //TpName(TpName),
    One,
    Times(Box<Type>, Box<Type>),
    Plus(Vec<(Label, Type)>),
    With(Vec<(Label, Type)>),
    Arrow(Box<Type>, Box<Type>),
    TpInst(TpName, Vec<Mode>),
    Down(Box<Type>),
    Up(Box<Type>),
    Flat(Mode, Box<Type>),
}

#[derive(Debug, PartialEq, Eq)]
pub enum Pat {
    InjPat(Label, Box<Pat>),
    PairPat(Box<Pat>, Box<Pat>),
    UnitPat,
    ShiftPat(Box<Pat>),
    VarPat(VarName),
}

#[derive(Debug, PartialEq, Eq)]
pub enum Exp {
    Var(VarName),
    Pair(Box<Exp>, Box<Exp>),
    Unit,
    Inj(Label, Box<Exp>),
    MatchWith(Box<Exp>, Vec<(Pat, Exp)>),
    Call(VarName, Vec<Atom>),
    Record(Vec<(Label,Exp)>),
    Fun(VarName, Box<Exp>),
    Shift(Box<Exp>),
    Susp(Box<Exp>),
}

#[derive(Debug, PartialEq, Eq)]
pub enum Atom {
    Exp(Exp),
    Dot(Label),
    Force,
}

#[derive(Debug, PartialEq, Eq)]
pub enum Defn {
    TypeDefn(TpName, Vec<Mode>, Type),
    ExpDefn(ExpName, Vec<(VarName, Type)>, Type, Exp),
    InstDefn(ExpName, Vec<(VarName, Type)>, Type),
}
