(** Abstract Syntax Trees for SAX *)

(* TYPES *)

    type label = string
    type tpname = string

    type tp = Times of tp * tp
            | One
            | Plus of (label * tp) list
            | TpName of tpname

    type varname = string
    type expname = string

    type pat = PairPat of pat * pat
             | UnitPat
             | InjPat of label * pat
             | VarPat of varname

    type exp = Var of varname
             | Pair of exp * exp
             | Unit
             | Inj of label * exp
             | MatchWith of exp * (pat * exp) list
             | Call of varname * exp list

    type parm = varname * tp

    type defn = TypeDefn of tpname * tp
              | ExpDefn of expname * parm list * tp * exp

    type env = defn list

    (** Print as source, with redundant parentheses *)
    (* these print redundant '(...)' and '{...}' *)
    
    module Print : sig
      val pp_tp : tp -> string
      val pp_pat : pat -> string
      val pp_exp : int -> exp -> string 
      val pp_defn : defn -> string
      val pp_env : env -> string
    end

