(* Terminal Symbols *)

(* Interface between lexer and parser *)

(* This allows pragmas, currently unused *)

signature TERMINAL =
sig

datatype terminal =
         LPAREN | RPAREN | LBRACE | RBRACE
       | EQ | COLON
       | BAR | RIGHTARROW | COMMA
       | STAR | PLUS | NAT of int
       | READ | WRITE | CUT | ID | CALL
       | TYPE | PROC | FAIL
       | VALUE
       | IDENT of string | LABEL of string
       | EOF | LEX_ERROR

val toString : terminal -> string

end

structure Terminal :> TERMINAL =
struct

datatype terminal =
         LPAREN | RPAREN | LBRACE | RBRACE
       | EQ | COLON
       | BAR | RIGHTARROW | COMMA
       | STAR | PLUS | NAT of int
       | READ | WRITE | CUT | ID | CALL
       | TYPE | PROC | FAIL
       | VALUE
       | IDENT of string | LABEL of string
       | EOF | LEX_ERROR

fun toString t =
    case t
     of LPAREN => "(" | RPAREN => ")" | LBRACE => "{" | RBRACE => "}"
      | EQ => "=" | COLON => ":"
      | BAR => "|" | RIGHTARROW => "=>" | COMMA => ","
      | STAR => "*" | PLUS => "+" | NAT(n) => Int.toString n
      | READ => "read" | WRITE => "write" | CUT => "cut" | ID => "id" | CALL => "call"
      | TYPE => "type" | PROC => "proc" | FAIL => "fail"
      | VALUE => "value"
      | IDENT(s) => s  | LABEL(l) => "'" ^ l
      | EOF => "<eof>" | LEX_ERROR => "<lex error>"

end (* structure Terminal *)
