(* Flags *)
(* Author: Frank Pfenning <fp@cs.cmu.edu> *)

(*
 * User option given on the command line 
 * plus the version number and date
 *)

signature FLAGS =
sig
    val parseBool : string -> bool option
    val pp_bool : bool -> string

    val verbosity : int ref
    val help : bool ref

    val parseInt : string -> int option
    val printDepth : int ref

    (* reset all flags to their default value *)
    val reset : unit -> unit

    val version : string
end  (* signature FLAGS *)

structure Flags :> FLAGS =
struct

fun parseBool "true" = SOME(true)
  | parseBool "false" = SOME(false)
  | parseBool _ = NONE

fun pp_bool true = "true"
  | pp_bool false = "false"

val verbosity = ref 1           (* ~1 = print nothing, 0 = quiet, 1 = normal, 2 = verbose, 3 = debug *)
val help = ref false

val printDepth = ref ~1         (* 0 = print none, < 0 = print all *)
fun parseInt s =
    (case Int.fromString s
      of NONE => NONE
       | SOME(n) => SOME(n))    (* pass through negative numbers *)

fun reset () =
    ( printDepth := ~1
    ; verbosity := 1
    ; help := false )

val version = "Sax <some version> <some date>"

end (* structure Flags *)
