%% 15-317 S'23
%% Homework 7
%% Certifying metainterpreter for (pure) Prolog

% Following clauses just fix the languages for
% for testing purposes.  They do not constrain
% the language to Horn clauses.

% proof terms
pterm(var(C)).
pterm(app(M,N)) :- pterm(M), pterm(N).
pterm(pair(M,N)) :- pterm(M), pterm(N).

% propositions
prop(atom(P)).
prop(imp(A,B)) :- prop(A), prop(B).
prop(and(A,B)) :- prop(A), prop(B).

% programs
prog([]).
prog([clause(C,A)|Gamma]) :- prop(A), prog(Gamma).

% your code to write
backchain(Gamma, M, atom(P)) :- fail.

%% examples (updated from lecture)

ex1([clause(c1,atom(p)),
     clause(c2,imp(atom(p),atom(q))),
     clause(c3,atom(q)),
     clause(c4,imp(atom(q), atom(r)))]).
query1(M) :- ex1(Gamma), backchain(Gamma, M, atom(r)).

ex2([clause(c1,imp(atom(p),atom(p))),
     clause(c2,atom(p))]).
query2(M) :- ex2(Gamma), backchain(Gamma, M, atom(p)).

ex3([clause(p0,atom(plus(0, Y, Y))),
     clause(ps,imp(atom(plus(X, Y, Z)), atom(plus(s(X), Y, s(Z)))))]).

query3(M,Z) :- ex3(Gamma),
             backchain(Gamma, M, atom(plus(s(0), s(s(0)), Z))).
query4(M,X,Y) :- ex3(Gamma),
                 backchain(Gamma, M, atom(plus(X, Y, s(s(s(s(0))))))).
query5(P) :- ex3(Gamma),
             backchain(Gamma, 
                       app(var(ps),app(var(ps),app(var(ps),app(var(ps),var(p0))))),
                       P).
