signature PROP =
sig

datatype prop =
         And of prop * prop
       | Imp of prop * prop
       | Or of prop * prop
       | True
       | False
       | Var of string

val Not : prop -> prop

val toString : prop -> string

end (* signature PROP *)

structure Prop :> PROP =
struct

datatype prop =
         And of prop * prop
       | Imp of prop * prop
       | Or of prop * prop
       | True
       | False
       | Var of string

fun Not A = Imp(A,False)

fun toString (And(A,B)) = "(" ^ toString A ^ " /\\ " ^ toString B ^ ")"
  | toString (Imp(A,B)) = "(" ^ toString A ^ " => " ^ toString B ^ ")"
  | toString (Or(A,B)) = "(" ^ toString A ^ " \\/ " ^ toString B ^ ")"
  | toString (True) = "T"
  | toString (False) = "F"
  | toString (Var(P)) = P

end
