(* 15-317 S23
 * SML as a "proof checker"
 * Frank Pfenning
 * Live-coded
 *)

datatype ('a,'b) sum = inl of 'a | inr of 'b
datatype zero = void of zero
type 'a not = 'a -> zero

(* case_ : ('a, 'b) sum * ('a -> 'c) * ('b -> 'c) -> 'c *)
fun case_ (M, F, G) = case M
                       of inl x => F x
                        | inr y => G y

(* abort : void -> 'c *)
fun abort (void _) = raise Fail "impossible"

fun fst (x,y) = x
fun snd (x,y) = y

(* supply definitions for the following values *)
(* use SOME(M) if there is a pure SML function of the given
 * type that represents a proof
 * use NONE if there is no proof
 *)
val curry : (('a * 'b -> 'c) -> 'a -> 'b -> 'c) option
val abba : ((('a -> 'b) -> 'b) -> 'a) option
val contrapositive : (('a -> 'b) -> ('b not -> 'a not)) option
val exclusion : (('a, 'b) sum * 'a not -> 'b) option

(* cut-and-paste the run of the file here *)
(* redacted example is below *)
(*
- use "hw2.sml";
[opening hw2-sol.sml]
datatype ('a,'b) sum = inl of 'a | inr of 'b
datatype zero = void of zero
type 'a not = 'a -> zero
val case_ = fn : ('a,'b) sum * ('a -> 'c) * ('b -> 'c) -> 'c
val abort = fn : zero -> 'a
val fst = fn : 'a * 'b -> 'a
val snd = fn : 'a * 'b -> 'b
val curry = ...
val abba = ...
val contrapositive = ...
val exclusion = ...
val it = () : unit
*)
