(* Translation from named to de Bruijn represention *)

signature TRANSLATE =
sig
    exception Error of string
    val translate: MinML.exp Stream.stream -> DBMinML.exp Stream.stream
end;  (* signature TRANSLATE *)

structure Translate :> TRANSLATE =
struct
    structure M = MinML
    structure DB = DBMinML
    structure S = Stream

    exception Error of string

    (* context for translation *)
    infix 1 ++
    fun (ctx ++ x') = x'::ctx
    (* lookup : M.var -> M.var list -> DB.var *)
    fun lookup x (x'::ctx) = if x = x' then 1 else 1 + lookup x ctx
      | lookup x nil = raise Error "Unbound variable"

    (* translation to DeBruijn representation *)
    (* translate' : M.var list -> M.exp -> DB.exp *)
    fun translate' ctx (M.Int n) = DB.Int n
      | translate' ctx (M.Bool b) = DB.Bool b
      | translate' ctx (M.If (e, e1, e2)) = DB.If (translate' ctx e,
                                                   translate' ctx e1,
                                                   translate' ctx e2)
      | translate' ctx (M.Primop (primop, elist)) =
        DB.Primop (primop, map (translate' ctx) elist)
      | translate' ctx (M.Fn (t, (x, e))) =
        DB.Fn (t, ((), translate' (ctx++x) e))
      | translate' ctx (M.Rec (t, (x, e))) =
        DB.Rec (t, ((), translate' (ctx++x) e))
      | translate' ctx (M.Let (e1, (x, e2))) =
        DB.Let (translate' ctx e1, ((), translate' (ctx++x) e2))
      | translate' ctx (M.Apply (e1, e2)) =
        DB.Apply (translate' ctx e1, translate' ctx e2)
      | translate' ctx (M.Var x) = DB.Var (lookup x ctx)
(* new asst4 code: *)
      | translate' ctx (M.Unit) = DB.Unit
      | translate' ctx (M.Pair (e1, e2)) =
	DB.Pair (translate' ctx e1, translate' ctx e2)
      | translate' ctx (M.Fst (e)) = DB.Fst (translate' ctx e)
      | translate' ctx (M.Snd (e)) = DB.Snd (translate' ctx e)

(* removed old asst4 code *)
(* end asst4 code *)

(* begin asst8 code *)
      | translate' ctx (M.Future (e)) = DB.Future (translate' ctx e)
      | translate' ctx (M.Promise (_)) = raise Match (* Impossible *)
      | translate' ctx (M.Leaf) = DB.Leaf
      | translate' ctx (M.Node (x,l,r)) = DB.Node (translate' ctx x,
                                                   translate' ctx l,
                                                   translate' ctx r)

      | translate' ctx (M.Case (e, e1, (x, l, r, e2))) =
        DB.Case (translate' ctx e,
                     translate' ctx e1,
                     ((), (), (), translate' (ctx++x++l++r) e2))
(* end asst8 code *)

    fun translate (s : M.exp S.stream) : DB.exp S.stream = 
        S.map (translate' nil) s

end;  (* structure Translate *)
