signature TOP =
sig
    (* interactive loop *)
    val loop_print : unit -> unit
    val loop_print_noDB : unit -> unit  (* print before translating to deBruijn form *)
    val loop_type  : unit -> unit
    val loop_eval  : int -> unit
    val loop_step  : int -> unit

    (* read a MinML source file *)
    val file_print : string -> unit
    val file_print_noDB : string -> unit (* print before translating to deBruijn form *)
    val file_type  : string -> unit
    val file_eval  : int -> string -> unit
    val file_step  : int -> string -> unit
end

structure Top :> TOP =
struct

(* Uncomment to run the stop-the-world collector *)
    structure Loop = Loop (structure M = AMach
                           structure G = StopTheWorldGC)

(* Uncomment to run the incremental collector
    structure Loop = Loop (structure M = AGMach
                           structure G = IncrementalGC)
*)

    fun loop_print () =
        (Loop.loop Loop.show)
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");

    fun loop_print_noDB () =
        (Loop.loop_noDB Loop.show_noDB)
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");

    fun loop_type () = 
        (Loop.loop Loop.showType)
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");

    fun loop_eval heapSize = 
        (Loop.loop (Loop.eval heapSize Loop.showType)) 
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");

    fun loop_step heapSize =
        (Loop.loop_state heapSize (Loop.step Loop.showState))
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");

    fun file_print f =
        (Loop.loopFile f Loop.show)
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");

    fun file_print_noDB f =
        (Loop.loopFile_noDB f Loop.show_noDB)
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");

    fun file_type  f = 
        (Loop.loopFile f Loop.showType)
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");

    fun file_eval heapSize f =
        (Loop.loopFile f (Loop.eval heapSize Loop.showType)) 
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");

    fun file_step heapSize f =
        (Loop.loopFile_state heapSize f (Loop.step Loop.showState))
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");
end
