/*
 * Header file for vecsum.c
 *
 */

/* vectors as structure containing length and raw array */
typedef struct {
  int len;
  int *data;
} vec;

vec *vnew(int len);		/* allocate and initialize new vector */
int vget(vec *p, int i, int *dest); /* return 0 if i out of bounds, else 1 */
int vset(vec *p, int i, int n);	/* returns 0 if i out of bounds, else 1 */
int vlen(vec *p);		/* length of vector */
int *vdata(vec* p);		/* raw array stored in vector */

/* different implementation of summing a vector */
void sum1(vec *p, int *dest);
void sum2(vec *p, int *dest);
void sum3(vec *p, int *dest);
void sum4(vec *p, int *dest);
