/**CHeaderFile*****************************************************************

  FileName    [error.h]

  PackageName [utils]

  Synopsis    [header for the error.c file]

  Description [header for the error.c file.]

  SeeAlso     []

  Author      [Marco Roveri]

  Copyright   [
  This file is part of the ``utils'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

  Revision    [$Id: error.h,v 1.1.1.1 2003/02/06 19:01:15 flerda Exp $]

******************************************************************************/

#ifndef _ERROR_H
#define _ERROR_H

#include "utils.h"
#include "node.h"
/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void init_the_node ARGS((void));
EXTERN void set_the_node ARGS((node_ptr));
EXTERN node_ptr get_the_node ARGS((void));
EXTERN void io_atom_pop ARGS((void));
EXTERN void io_atom_push ARGS((node_ptr));
EXTERN void start_parsing_err ARGS((void));
EXTERN void finish_parsing_err ARGS((void));
EXTERN void nusmv_exit ARGS((int));
EXTERN void rpterr ARGS((const char *, ...));
EXTERN void internal_error ARGS((const char *, ...)) NORETURN;
EXTERN void error_multiple_substitution ARGS((node_ptr));
EXTERN void division_by_zero ARGS((void));
EXTERN void range_error ARGS((node_ptr, node_ptr));
EXTERN void type_error ARGS((node_ptr));
EXTERN void error_redefining ARGS((node_ptr));
EXTERN void error_undefined ARGS((node_ptr));
EXTERN void error_circular ARGS((node_ptr));
EXTERN void error_too_many_vars ARGS((void));
EXTERN void error_not_a_number ARGS((node_ptr));
EXTERN void error_multiple_assignment ARGS((node_ptr));
EXTERN void error_empty_range ARGS((node_ptr, int, int));
EXTERN void error_assign_both ARGS((node_ptr, node_ptr, int, int));
EXTERN void error_multiple_substitution ARGS((node_ptr));
EXTERN void error_unknown_var_in_order_file ARGS((node_ptr));
EXTERN void error_var_appear_twice_in_order_file ARGS((node_ptr));
EXTERN void warning_var_appear_twice_in_order_file ARGS((node_ptr));
EXTERN void warning_variable_not_declared ARGS((node_ptr));
EXTERN void warning_missing_variable ARGS((node_ptr));
EXTERN void error_var_not_in_order_file ARGS((node_ptr));
EXTERN void error_out_of_memory ARGS((long));
EXTERN void init_memory ARGS((void));

#include <setjmp.h>
#if SOLARIS
#define JMPBUF sigjmp_buf
#define SETJMP(buf,val) sigsetjmp(buf, val)
#define LONGJMP(buf,val) siglongjmp(buf, val)
#else
#define JMPBUF jmp_buf
#define SETJMP(buf,val) setjmp(buf)
#define LONGJMP(buf,val) longjmp(buf, val)
#endif

EXTERN JMPBUF * util_newlongjmp ARGS((void));
EXTERN void util_longjmp ARGS((void));
EXTERN void util_cancellongjmp ARGS((void));
EXTERN void util_resetlongjmp ARGS((void));
#define util_setlongjmp() SETJMP(*(util_newlongjmp()), 1)
#define CATCH if (util_setlongjmp() == 0) { 
#define FAIL  util_cancellongjmp(); } else

#endif /* _ERROR_H */
