/**CFile***********************************************************************

  FileName    [smInit.c]

  PackageName [sm]

  Synopsis    [Initializes and ends NuSMV.]

  Author      [Adapted to NuSMV by Marco Roveri]

  Copyright   [
  This file is part of the ``sm'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#include "smInt.h"

static char rcsid[] UTIL_UNUSED = "$Id: smInit.c,v 1.1.1.1 2003/02/06 19:01:16 flerda Exp $";

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/**Function********************************************************************

  Synopsis    [Calls the initialization routines of all the packages.]

  SideEffects [Sets the global variables nusmv_stdout, nusmv_stderr,
  nusmv_historyFile.]

  SeeAlso     [SmEnd]

******************************************************************************/
void
SmInit(
   )
{
  init_memory();
  cmdFlagTable = avl_init_table(strcmp);
  nusmv_stdout     = stdout;
  nusmv_stderr     = stderr;
  nusmv_stdin      = stdin;
  nusmv_historyFile = NIL(FILE);

  init_string();
  node_init();

  init_symbol_hash();
  init_param_hash();
  init_constant_hash();
  init_print_hash();
  init_value_hash();
  init_traces_hash();
  init_check_constant_hash();
  init_wfftype_hash();
  init_assign_db_hash();
  init_variable_sexp_model_hash();
  init_flatten_def_hash();
  init_flatten_constant_hash();
  init_dependencies_hash();
  init_define_dep_hash();
  init_coi_hash();
  init_eval_hash();
  dd_manager = init_dd_package();
  init_the_node();
  Prop_InitPropMaster();
  Prop_Db_Init();

  Cmd_Init();
  options = init_options();

  /* Other init here */
  sm_AddCmd();
  dd_AddCmd();
  Parser_Init();
  Compile_Init();
  Prop_Init();
  Mc_Init();
  Ltl_Init();
  Simulate_Init();
  Bmc_AddCmd();
}


/**Function********************************************************************

  Synopsis    [Calls the end routines of all the packages.]

  SideEffects [Closes the output files if not the standard ones.]

  SeeAlso     [SmInit]

******************************************************************************/
void
SmEnd(
   )
{
  Cmd_End();
  Compile_End();
  Prop_End();
  Mc_End();
  
  if (nusmv_stdout != stdout) {  
    (void) fclose(nusmv_stdout);
  } 
  if (nusmv_stderr != stderr) {
    (void) fclose(nusmv_stderr);
  }
  if (nusmv_historyFile != NIL(FILE)) {
    (void) fclose(nusmv_historyFile);
  }
  if (nusmv_stdin != stdin) {  
    (void) fclose(nusmv_stdin);
  } 

  clear_symbol_hash();
  clear_param_hash();
  clear_constant_hash();
  clear_print_hash();
  clear_value_hash();
  clear_traces_hash();
  clear_check_constant_hash();
  clear_wfftype_hash();
  clear_module_hash();

#ifdef DEBUG
  if (opt_verbose_level_gt(options, 4)) {
    int result = dd_checkzeroref(dd_manager);
    if (result != 0) {
      fprintf(stderr,"%d non-zero DD reference counts after dereferencing\n", result);
    }
  }
#endif
  clear_flatten_def_hash();
  clear_assign_db_hash();
  clear_variable_sexp_model_hash();
  clear_flatten_constant_hash();
  clear_dependencies_hash();
  clear_define_dep_hash();
  clear_coi_hash();
  clear_eval_hash();
  Prop_Db_Quit();
  Prop_QuitPropMaster();
  quit_dd_package(dd_manager);  
  nusmv_stdout = stdout;
  nusmv_stderr = stderr;
  nusmv_stdin  = stdin;
  nusmv_historyFile = NIL(FILE);
}
