/**CFile***********************************************************************

  FileName    [smCmd.c]

  PackageName [sm]

  Synopsis    [Interface of the sm package with the shell.]

  Description [Interface of the sm package with the shell.]

  SeeAlso     []

  Author      [Adapted to NuSMV by Marco Roveri]

  Copyright   [
  This file is part of the ``sm'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/
#include "smInt.h" 

static char rcsid[] UTIL_UNUSED = "$Id: smCmd.c,v 1.1.1.1 2003/02/06 19:01:16 flerda Exp $";

int CommandCmdReset(int argc, char **argv);
int CommandPrintUsage(int argc, char **argv);
/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/
static int UsageCmdReset ARGS((void));
static int UsagePrintUsage ARGS((void));
/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/
void sm_AddCmd(void){
  Cmd_CommandAdd("reset", CommandCmdReset, 0);
  Cmd_CommandAdd("print_usage", CommandPrintUsage, 0);
}

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis           [Implements the reset command.]

  CommandName        [reset] 	   

  CommandSynopsis    [Resets the whole system.]  

  CommandArguments   [\[-h\]]  

  CommandDescription [Resets the whole system, in order to read in
  another model and to perform verification on it.
  <p>
  Command options:<p>
  <dl>
    <dt> -h
       <dd> Prints the command usage.
  </dl>]  

  SideEffects        []

******************************************************************************/
int CommandCmdReset(int argc, char ** argv)
{
  int c;

  util_getopt_reset();
  while((c = util_getopt(argc,argv,"h")) != EOF){
    switch(c){
    case 'h': return(UsageCmdReset());
    default:  return(UsageCmdReset());
    }
  }
  if (argc != util_optind) return(UsageCmdReset());

  if (opt_verbose_level_gt(options, 2))
    fprintf(nusmv_stderr, "Clearing all the hashes used by the compiler....");
  clear_symbol_hash();
  clear_param_hash();
  clear_constant_hash();
  clear_print_hash();
  clear_value_hash();
  clear_traces_hash();
  clear_check_constant_hash();
  clear_wfftype_hash();
  /* Clear the module hash */
  clear_module_hash();
  clear_flatten_def_hash();
  clear_flatten_constant_hash();
  clear_assign_db_hash();
  clear_variable_sexp_model_hash();
  clear_dependencies_hash();
  clear_define_dep_hash();
  clear_coi_hash();
  clear_eval_hash();

  { /* Frees the list of state variables */
    node_ptr l = state_variables;

    while(l != Nil) {
      node_ptr m = l;

      l = cdr(l);
      free_node(m);
    }
  }
  { /* Frees the list of input variables */
    node_ptr l = input_variables;

    while(l != Nil) {
      node_ptr m = l;

      l = cdr(l);
      free_node(m);
    }
  }
  { /* Frees the list of variables */
    node_ptr l = all_variables;

    while(l != Nil) {
      node_ptr m = l;

      l = cdr(l);
      free_node(m);
    }
  }
  { /* Frees the list of variables */
    node_ptr l = all_symbols;

    while(l != Nil) {
      node_ptr m = l;

      l = cdr(l);
      free_node(m);
    }
  }
  free_boolean_variable_list();
  if (opt_verbose_level_gt(options, 2)) {
    fprintf(nusmv_stderr, "Done!!\n");
    fprintf(nusmv_stderr, "Clearing the DD package....\n");
  }
  walk_dd(dd_manager, add_free, real_state_variables);
  if (state_variables_bdd  != (bdd_ptr)NULL)
    bdd_free(dd_manager, state_variables_bdd);
  if (state_variables_add  != (add_ptr)NULL)
    add_free(dd_manager, state_variables_add);
  if (input_variables_bdd != (bdd_ptr)NULL)
    bdd_free(dd_manager, input_variables_bdd);
  if (input_variables_add != (add_ptr)NULL)
    add_free(dd_manager, input_variables_add);
  if (next_state_variables_bdd != (bdd_ptr)NULL)
    bdd_free(dd_manager, next_state_variables_bdd);
  if (next_state_variables_add != (add_ptr)NULL)
    add_free(dd_manager, next_state_variables_add);
  if (next_input_variables_bdd != (bdd_ptr)NULL)
    bdd_free(dd_manager, next_input_variables_bdd);
  if (next_input_variables_add != (add_ptr)NULL)
    add_free(dd_manager, next_input_variables_add);
  free_minterm_vars();
  if (reachable_states_bdd != (bdd_ptr)NULL)
    bdd_free(dd_manager, reachable_states_bdd);
  if (reachable_states_layers != Nil)
    walk_dd(dd_manager, bdd_free, reachable_states_layers);
  { /* Frees the list of reachable states layers */
    node_ptr l = reachable_states_layers;
    
    while(l != Nil) {
      node_ptr m = l;

      l = cdr(l);
      free_node(m);
    }
  }
  current_state_bdd_free();
#ifdef DEBUG
  if (opt_verbose_level_gt(options, 4)) {
    int result = dd_checkzeroref(dd_manager);
    if (result != 0) {
      fprintf(nusmv_stderr,
	      "\n%d non-zero DD reference counts after dereferencing.\n", result);
    }
  }
#endif
  Prop_QuitPropMaster();
  Prop_Db_Quit();
  quit_dd_package(dd_manager);

  /* reset rbc package */
  Bmc_Quit();
  node_quit();

  if (opt_verbose_level_gt(options, 2)) {
    fprintf(nusmv_stderr, "Done!!\n\n");
    fprintf(nusmv_stderr, "Restarting the DD manager....");
  }

  node_init();
  dd_manager = init_dd_package();
  init_the_node();

  if (opt_verbose_level_gt(options, 2)) {
    fprintf(nusmv_stderr, "Done!!\n");
    fprintf(nusmv_stderr, "Resetting the compiler....");
  }
  cmps = cmp_struct_init();  /* reset all the flags */
  reset_input_order_file(options);
  reset_output_order_file(options);
  reset_encode();

  reset_trace_number();
  reset_boolean_variable_list();
  state_variables = Nil;
  all_symbols = Nil;
  all_variables = Nil;
  input_variables = Nil;
  real_state_variables = Nil;
  reset_minterm_vars_dim();
  state_variables_add  = (add_ptr)NULL;
  state_variables_bdd  = (bdd_ptr)NULL;
  next_state_variables_add = (add_ptr)NULL;
  next_state_variables_bdd = (bdd_ptr)NULL;
  input_variables_add = (add_ptr)NULL;
  input_variables_bdd = (bdd_ptr)NULL;
  next_input_variables_add = (add_ptr)NULL;
  next_input_variables_bdd = (bdd_ptr)NULL;

  reachable_states_bdd = (bdd_ptr)NULL;
  reachable_states_layers = Nil;

  current_state_label_reset();
  current_state_bdd_reset();

  Prop_InitPropMaster();
  Prop_Db_Init();

  if (opt_verbose_level_gt(options, 2)) fprintf(nusmv_stderr, "Done!!\n");
  return(0);
}

static int UsageCmdReset()
{
  fprintf(nusmv_stderr, "usage: reset [-h]\n");
  fprintf(nusmv_stderr, "   -h \t\tPrints the command usage.\n");
  return(1);
}


/**Function********************************************************************

  Synopsis           [Implements the print_usage command.]

  CommandName        [print_usage] 	   

  CommandSynopsis    [Prints processor and BDD statistics.]  

  CommandArguments   [\[-h\]]  

  CommandDescription [Prints a formatted dump of processor-specific
  usage statistics, and BDD usage statistics. For Berkeley Unix, this
  includes all of the information in the <tt>getrusage()</tt> structure.
  <p>
  Command options:<p>
  <dl>
    <dt> -h
       <dd> Prints the command usage.
  </dl>]  

  SideEffects        [required]

******************************************************************************/
int CommandPrintUsage(int argc, char **argv)
{
  int c;

  util_getopt_reset();
  while((c = util_getopt(argc,argv,"h")) != EOF){
    switch(c) {
    case 'h': return(UsagePrintUsage());
    default:  return(UsagePrintUsage());
    }
  }
  /* Reporting of statistical information. */
  print_usage(nusmv_stdout);
  return(0);
}

static int UsagePrintUsage()
{
  fprintf(nusmv_stderr, "usage: print_usage [-h]\n");
  fprintf(nusmv_stderr, "   -h \t\tPrints the command usage.\n");
  return(1);
}



