 /**CHeaderFile*****************************************************************

  FileName    [simulateInt.h]

  PackageName [simulate]

  Synopsis    [Internal Header File for the simulate package]

  Description [Internal Header File for the simulate package]

  SeeAlso     [simulate.c]

  Author      [Andrea Morichetti]

  Copyright   [
  This file is part of the ``simulate'' package of NuSMV version 2. 
  Copyright (C) 1998-2001 by CMU and ITC-irst. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

  Revision    [$Id: simulateInt.h,v 1.1.1.1 2003/02/06 19:01:18 flerda Exp $]

******************************************************************************/

#ifndef _SIMULATEINT
#define _SIMULATEINT

#include <stdio.h>
#include <stdlib.h>

#if HAVE_SYS_SIGNAL_h
#  include <sys/signal.h>
#endif
#if HAVE_SIGNAL_H
#  include <signal.h>
#endif

#include <setjmp.h>

#include <assert.h>

#include "sm.h"
#include "util.h"
#include "utils.h"
#include "node.h"
#include "dd.h"
#include "rbc.h"
#include "set.h"
#include "grammar.h"
#include "parser.h"
#include "compile.h"
#include "img.h"
#include "opt.h"
#include "prop.h"
#include "mc.h"
#include "cmd.h"
#include "simulate.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
/* maximum length of the string containing constraints */
#define CONSTR_LENGTH 256
/* Length of the string used for the choice entered in interac. sim.*/
#define CHOICE_LENGTH 8


extern DdManager * dd_manager;
extern options_ptr options;
extern cmp_struct_ptr cmps;
extern int trace_number;
extern bdd_ptr minterm_vars[];
extern node_ptr all_symbols;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
EXTERN int Simulate_CmdPickOneState ARGS((Fsm_BddPtr, Simulation_Mode, int, char *));
EXTERN int Simulate_CmdShowTraces ARGS((int, int, boolean, char *));

#endif /* _SIMULATEINT */
