/**CHeaderFile*****************************************************************

  FileName    [satUtils.h]

  PackageName [sat]

  Synopsis    [Utilities interface for the sat package]

  Description []

  SeeAlso     []

  Author      [Roberto Cavada]

  Copyright   [
  This file is part of the ``sat'' package of NuSMV version 2.
  Copyright (C) 2000-2001 by ITC-irst and University of Trento.

  NuSMV version 2 is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#ifndef _SAT_UTILS_H
#define _SAT_UTILS_H

#include "util.h" /* for EXTERN and ARGS */


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

/**Enum**********************************************************************

  Synopsis    [Sat_SatSolver_Type is a symbolic name for a sat solver 
  instance]

  Description []

  SeeAlso     []

******************************************************************************/
typedef enum {Sat_Error=-1, Sat_Sim=0, Sat_ZChaff=1} Sat_SatSolver_Type;

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/

/**Macro**********************************************************************

  Synopsis    [Returns the number of element in a statically allocated array]

  Description []

  SeeAlso     []

******************************************************************************/
#define GET_ARRAY_LENGTH(array) \
  (sizeof(array)/sizeof(array[0]))


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN const char* 
Sat_GetSatSolverString ARGS((const Sat_SatSolver_Type type));

EXTERN Sat_SatSolver_Type
Sat_GetSatSolverType ARGS((const char* str_name));

EXTERN void Sat_PrintAvailableSolvers ARGS((FILE* file));


/**AutomaticEnd***************************************************************/

#endif /* _SAT_UTILS_H */
