/**CFile***********************************************************************

  FileName    [satUtils.c]

  PackageName [sat]

  Synopsis    [Sat utilities module]

  Description []

  SeeAlso     []

  Author      [Roberto Cavada]

  Copyright   [
  This file is part of the ``sat'' package of NuSMV version 2. 
  Copyright (C) 2000-2001 by ITC-irst and University of Trento. 

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#include "satUtils.h"

#include "utils.h"
#include <string.h>


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

/**Variable*******************************************************************
  Synopsis           [The sat solvers names NuSMV provides]
  Description        []
  SideEffects        []
  SeeAlso            []
******************************************************************************/
static const char* sat_solver_names[] = {
  "Sim"
# ifdef SAT_ENABLE_ZCHAFF_SOLVER
  ,"ZChaff"
# endif
};


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis           [Given the symbolic name of a sat solver instance, 
  returns the readable name as a string]

  Description        []

  SideEffects        []

  SeeAlso            []
******************************************************************************/
const char* Sat_GetSatSolverString(const Sat_SatSolver_Type type)
{
  int idx = (int) type;
  nusmv_assert((idx >= 0) && (idx < GET_ARRAY_LENGTH(sat_solver_names)));
  return sat_solver_names[idx];
}


/**Function********************************************************************

  Synopsis           [Given the readable string (case insensitive) of 
  a sat solver instance, returns corresponding the symbolic name if there
  is one, Sat_Error otherwise]

  Description        []

  SideEffects        []

  SeeAlso            []
******************************************************************************/
Sat_SatSolver_Type Sat_GetSatSolverType(const char* str_name)
{
  int i;
  Sat_SatSolver_Type ret = Sat_Error;

  for (i=0; i<GET_ARRAY_LENGTH(sat_solver_names); ++i) {
    if (strcasecmp(str_name, sat_solver_names[i]) == 0) {
      ret = (Sat_SatSolver_Type) i;
    }
  }

  return ret;
}


/**Function********************************************************************

  Synopsis           [Prints out the sat solvers names the system currently 
  supplies]

  Description        []

  SideEffects        []

  SeeAlso            []
******************************************************************************/
void Sat_PrintAvailableSolvers(FILE* file)
{
  int i;
  fprintf(file, "The available SAT solvers are: ");
  for (i=0; i<GET_ARRAY_LENGTH(sat_solver_names); ++i) {
    fprintf(file, "%s ", sat_solver_names[i]);
  }
  fprintf(file, "\n");
}

/**AutomaticEnd***************************************************************/
