/**CHeaderFile*****************************************************************

  FileName    [satSolver.h]

  PackageName [sat]

  Synopsis    [Interface for the generic sat solver type]

  Description []

  SeeAlso     []

  Author      [Roberto Cavada]

  Copyright   [
  This file is part of the ``sat'' package of NuSMV version 2.
  Copyright (C) 2000-2001 by ITC-irst and University of Trento.

  NuSMV version 2 is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/

#ifndef _SAT_SOLVER_H
#define _SAT_SOLVER_H


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

/**Struct**********************************************************************

  Synopsis    []

  Description []

  SeeAlso     []

******************************************************************************/
typedef struct Sat_SatSolver_TAG* Sat_SatSolver_ptr;


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
#include "sat.h"
#include "be.h"

EXTERN void 
Sat_SatSolver_Solve ARGS((const Sat_SatSolver_ptr self, 
			  const Be_Cnf_ptr cnfProb, Sat_SatResult_ptr result));

EXTERN const char* 
Sat_SatSolver_GetName ARGS((const Sat_SatSolver_ptr self));

EXTERN long 
Sat_SatSolver_GetLastSolvingTime ARGS((const Sat_SatSolver_ptr self));

#endif /* _SAT_SOLVER_H */
