/**CHeaderFile*****************************************************************

  FileName    [sat.h]

  PackageName [sat]

  Synopsis    [The public interface for the <tt>sat</tt> package]

  Description [This package contains the generic interface to access 
  to sat solvers. A set of specific Sat solvers implementation are internally 
  kept, and are not accessible]

  SeeAlso     []

  Author      [Roberto Cavada]

  Copyright   [
  This file is part of the ``sat'' package of NuSMV version 2.
  Copyright (C) 2000-2001 by ITC-irst and University of Trento.

  NuSMV version 2 is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

******************************************************************************/


#ifndef _SAT_H_
#define _SAT_H_

/* ====================================================================== */
/* Sat_Result class:  */

#include "utils.h"
#include "be.h"
#include "list.h"
#include "node.h"

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

/**Enum**********************************************************************

  Synopsis    [sat_result is used to represent the sat solver action outcome]

  Description [Internally used into the Sat_Result class.]

  SeeAlso     []

******************************************************************************/
typedef enum sat_result_TAG
{ SAT_INTERNAL_ERROR=-1, 
  SAT_TIMEOUT, 
  SAT_MEMOUT, 
  SAT_SATISFIABLE_PROBLEM, 
  SAT_UNSATISFIABLE_PROBLEM, 
  SAT_UNAVAILABLE
} sat_result;


/**Struct**********************************************************************

  Synopsis    [The structure returned from a Sat solver invokation]

  Description [Contains the sat outcome, in terms of success/unsuccess/failure
  and the possible propositional model has been found.]

  SeeAlso     []

******************************************************************************/
typedef struct Sat_SatResult_TAG* Sat_SatResult_ptr;


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

#include "satSolver.h"
#include "satUtils.h"


EXTERN Sat_SatResult_ptr 
Sat_SatResult_Create ARGS(());

EXTERN void Sat_SatResult_Delete ARGS((Sat_SatResult_ptr* sr_ref));


EXTERN lsList Sat_SatResult_GetListToCreatePropositionalModel
ARGS((const Sat_SatResult_ptr self));

EXTERN lsList Sat_SatResult_GetPropModel
ARGS((const Sat_SatResult_ptr self));


EXTERN boolean 
Sat_SatResult_IsSatisfiable ARGS((const Sat_SatResult_ptr sr));

EXTERN boolean 
Sat_SatResult_IsUnsatisfiable ARGS((const Sat_SatResult_ptr sr));

EXTERN boolean 
Sat_SatResult_IsError ARGS((const Sat_SatResult_ptr sr));

EXTERN boolean 
Sat_SatResult_IsNotAvailable ARGS((const Sat_SatResult_ptr sr));

EXTERN void 
Sat_SatResult_SetSatisfiable ARGS((Sat_SatResult_ptr sr));

EXTERN void 
Sat_SatResult_SetUnsatisfiable ARGS((Sat_SatResult_ptr sr));

EXTERN void
Sat_SatResult_SetInternalError ARGS((Sat_SatResult_ptr sr));

EXTERN void
Sat_SatResult_SetNotAvailable ARGS((Sat_SatResult_ptr sr));


/* ====================================================================== */
/* Package layer interface */
EXTERN void Sat_Init ARGS((void)); 
EXTERN void Sat_Quit ARGS((void)); 
EXTERN Sat_SatSolver_ptr Sat_GetSelectedSolver ARGS((Sat_SatSolver_Type));
/* ====================================================================== */

#endif /* _SAT_H_ */
